--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	~MRAY_ARCH_AND_DESIGN~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x70b05735L, 0x4a163654L) --Arch and Design Material
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYSICAL_MATERIAL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x3d6b1cecL, 0xdeadc001L) --Physical Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--Internal function that does the parameter mapping
fn ConvertFrom_ArchAndDesignToPhysical source dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)

	dest.base_color = source.diff_color
	if(source.diff_color.controller != undefined) do dest.base_color.controller = source.diff_color.controller
	dest.base_weight = source.diff_weight
	if(source.diff_weight.controller != undefined) do dest.base_weight.controller = source.diff_weight.controller
	dest.diff_roughness = source.diff_rough
	if(source.diff_rough.controller != undefined) do dest.diff_roughness.controller = source.diff_rough.controller
	dest.refl_color =  source.refl_color
	if(source.refl_color.controller != undefined) do dest.refl_color.controller = source.refl_color.controller

    dest.base_color_map_on = source.diff_color_map_on
    dest.base_color_map     = source.diff_color_map
    dest.refl_color_map_on = source.refl_color_map_on
    dest.refl_color_map      = source.refl_color_map
	
	-- adjust roughness interpretations; may need adjusting further
	dest.roughness = 1.0 - (pow (1.0 - source.refl_gloss) 1.5)
	dest.roughness_inv = true

	if source.refl_metal then (
		-- for now zero, coz we modify reflection color instead...
		-- ...this matches more what A&D actually does for "Metals"
		dest.metalness = 0.0 
		dest.refl_color = dest.refl_color * dest.base_color
		
		-- If there is a base color map, override the reflection color map with it
		-- for the metal case....
		if dest.base_color_map != undefined and dest.base_color_map_on do
		(
			dest.refl_color_map_on = true
			dest.refl_color_map = dest.base_color_map
		)		
	)
	else
	(
		dest.metalness = 0.0
	)

	dest.reflectivity = source.refl_weight 
	if(source.refl_weight.controller != undefined) do dest.reflectivity.controller = source.refl_weight.controller 

	if source.refr_falloff_on and source.refr_falloff_color_on then
	(
		dest.trans_color  = source.refr_falloff_color
		if(source.refr_falloff_color.controller != undefined) do dest.trans_color.controller = source.refr_falloff_color.controller 
		dest.trans_depth = source.refr_falloff_dist 
		if(source.refr_falloff_dist.controller != undefined) do dest.trans_depth.controller = source.refr_falloff_dist.controller 
		
		dest.trans_color_map_on = source.refr_falloff_color_map_on 
		dest.trans_color_map      = source.refr_falloff_color_map   		
	)
	else
	(
		dest.trans_color = source.refr_color
		if(source.refr_color.controller != undefined) do dest.trans_color.controller = source.refr_color.controller 
		
		dest.trans_color_map_on = source.refr_color_map_on 
		dest.trans_color_map      = source.refr_color_map
	)

	-- adjust roughness interpretations; may need adjusting further
	dest.trans_roughness= 1.0 - (pow (1.0 - source.refr_gloss) 1.5)
	dest.trans_roughness_inv = true
	dest.trans_roughness_lock = false
	dest.trans_ior = source.refr_ior
	if(source.refr_ior.controller != undefined) do dest.trans_ior.controller = source.refr_ior.controller 
	dest.transparency =  source.refr_weight
	if(source.refr_weight.controller != undefined) do dest.transparency.controller = source.refr_weight.controller

	-- Some special case treatement for wierdly set up materials with black (or low) trasparency color
	-- Only when: No texture map, and no controller....
	if ((dest.trans_color_map_on == false or dest.trans_color_map == undefined) and
		 dest.transparency.controller == undefined and dest.trans_color.controller == undefined) do
	(
		local tc = dest.trans_color
		-- compute maximum
		local mx = tc.r
		if tc.g > mx do mx = tc.g
		if tc.b > mx do mx = tc.b
		-- turn to float
		mx = mx / 255.0
		-- scale transparency by it
		dest.transparency = dest.transparency * mx
		-- If nonzero, divide it out from transparency color
		if (mx > 0.0 and mx < 1.0) do
		(
			dest.trans_color.r = dest.trans_color.r / mx
			dest.trans_color.g = dest.trans_color.g / mx
			dest.trans_color.b = dest.trans_color.b / mx
		)
	)

	dest.anisotropy = source.anisotropy 
	if(source.anisotropy.controller != undefined) do dest.anisotropy.controller = source.anisotropy.controller
	dest.anisoangle = source.anisoangle 
	if(source.anisoangle.controller != undefined) do dest.anisoangle.controller = source.anisoangle.controller
	dest.aniso_mode = source.aniso_mode
	dest.aniso_channel = source.aniso_channel 

	if source.refl_func_fresnel then
	(
		dest.brdf_mode  = true
	)
	else
	(
		dest.brdf_mode = false
	    dest.brdf_low    = source.refl_func_low 
		if(source.refl_func_low.controller != undefined) do dest.brdf_low.controller = source.refl_func_low.controller
	    dest.brdf_high   = source.refl_func_high 
		if(source.refl_func_high.controller != undefined) do dest.brdf_high.controller = source.refl_func_high.controller
	    dest.brdf_curve = source.refl_func_curve 
		if(source.refl_func_curve.controller != undefined) do dest.brdf_curve.controller = source.refl_func_curve.controller
	)

	dest.thin_walled = source.opts_1sided 

    dest.diff_rough_map_on = source.diff_rough_map_on
	dest.diff_rough_map      = source.diff_rough_map
    dest.roughness_map_on  = source.refl_gloss_map_on 
    dest.roughness_map      = source.refl_gloss_map

	dest.anisotropy_map_on = source.anisotropy_map_on
	dest.anisotropy_map      = source.anisotropy_map

	dest.aniso_angle_map_on  = source.anisoangle_map_on
	dest.aniso_angle_map       = source.anisoangle_map
	
	dest.trans_rough_map_on = source.refr_gloss_map_on
	dest.trans_rough_map      = source.refr_gloss_map

	dest.trans_ior_map_on     = source.refr_ior_map_on
	dest.trans_ior_map          = source.refr_ior_map

	dest.scattering_map_on = source.refr_transw_map_on
	dest.scattering_map      = source.refr_transw_map
	dest.sss_color_map_on = source.refr_transc_map_on 
	dest.sss_color_map      = source.refr_transc_map

	dest.emit_color_map_on = source.self_illum_map_on
	dest.emit_color_map      = source.self_illum_map
	
	dest.bump_map_on = 	  source.bump_map_on
	dest.bump_map    = 	  source.bump_map
	dest.bump_map_amt    = 	  source.bump_map_amt
	
	dest.displacement_map_on = 	  source.displacement_map_on
	dest.displacement_map    = 	  source.displacement_map
	dest.displacement_map_amt    = 	  source.displacement_map_amt
	
	dest.cutout_map_on = 	  source.cutout_map_on
	dest.cutout_map    = 	  source.cutout_map

	if source.refr_trans_on then
	(
	  dest.sss_color = source.refr_transc
	  if(source.refr_transc.controller != undefined) do dest.sss_color.controller = source.refr_transc.controller
	  dest.sss_depth = 5 -- just random number for now....
	  dest.sss_scale = 1.0
		-- In A&D, translucency is a "part" of transparency, but not in the Physical Material
		-- so we need to reduce transparency proportional to translucency...
	   dest.transparency = dest.transparency * (1.0 - source.refr_transw)
		--...that means the absolute weight of scattering is a ratio off the transparency...
	   dest.scattering = source.refr_transw * source.refr_weight
	)
	else
	(
		dest.scattering = 0.0
	)

	if source.self_illum_on then
	(
		dest.emission    = 1.0
		dest.emit_color  = source.self_illum_color_filter
		if(source.self_illum_color_filter.controller != undefined) do dest.emit_color.controller = source.self_illum_color_filter.controller
		
		if source.self_illum_int_mode then
		(
			-- The tricky case....
			
			local physical_scale = 1500

			local p = SceneExposureControl.exposureControl

			if p != undefined do (
				physical_scale = p.physical_scale
			)

			dest.emit_luminance = source.self_illum_int_arbitrary / 3.1415 * physical_scale
		)
		else
		(
			-- The simple case....
			dest.emit_luminance = source.self_illum_int_physical
			if(source.self_illum_int_physical.controller != undefined) do dest.emit_luminance.controller = source.self_illum_int_physical.controller
		)
		
		dest.emit_kelvin = source.self_illum_color_kelvin
		if(source.self_illum_color_kelvin.controller != undefined ) do dest.emit_kelvin.controller = source.self_illum_color_kevin.controller
	)
	else
	(
		dest.emission = 0.0
	)
	
	Dest
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case a default object is created and returned.
fn DefaultConversion source /*Not use*/=
(
	--Create the dest material
	newMat = PhysicalMaterial()
	
	--return the new material
	newMat

)

--Main entry point from this script
--This function handles the material's creation
fn Conversion archandDesignMat =
(
	if (false == VerifySource archandDesignMat )  do
	(
		--Not the suitable node
		return undefined
	)	
	
	--Create the dest material
	newMat = PhysicalMaterial()
	
	--Call the parameters mapping function to convert
	ConvertFrom_ArchAndDesignToPhysical archandDesignMat newMat
	
	if (IsProperty archandDesignMat "name") and (undefined != archandDesignMat.name) and (String == classof archandDesignMat.name)  and (IsProperty newMat "name") do
	(
		newMat.name = archandDesignMat.name
	)
	
	--return the new material
	newMat
)
